/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.services.cloudfront.model.CustomOrigin;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.RequiredProtocols;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionConfig {
    private S3Origin s3Origin;
    private CustomOrigin customOrigin;
    private String callerReference;
    private List<String> cNAME;
    private String comment;
    private Boolean enabled;
    private LoggingConfig logging;
    private TrustedSigners trustedSigners;
    private RequiredProtocols requiredProtocols;
    private String defaultRootObject;

    public DistributionConfig() {
    }

    public DistributionConfig(String callerReference, Boolean enabled) {
        this.callerReference = callerReference;
        this.enabled = enabled;
    }

    public S3Origin getS3Origin() {
        return this.s3Origin;
    }

    public void setS3Origin(S3Origin s3Origin) {
        this.s3Origin = s3Origin;
    }

    public DistributionConfig withS3Origin(S3Origin s3Origin) {
        this.s3Origin = s3Origin;
        return this;
    }

    public CustomOrigin getCustomOrigin() {
        return this.customOrigin;
    }

    public void setCustomOrigin(CustomOrigin customOrigin) {
        this.customOrigin = customOrigin;
    }

    public DistributionConfig withCustomOrigin(CustomOrigin customOrigin) {
        this.customOrigin = customOrigin;
        return this;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public void setCallerReference(String callerReference) {
        this.callerReference = callerReference;
    }

    public DistributionConfig withCallerReference(String callerReference) {
        this.callerReference = callerReference;
        return this;
    }

    public List<String> getCNAME() {
        if (this.cNAME == null) {
            this.cNAME = new ArrayList<String>();
        }
        return this.cNAME;
    }

    public void setCNAME(Collection<String> cNAME) {
        if (cNAME == null) {
            this.cNAME = null;
            return;
        }
        ArrayList<String> cNAMECopy = new ArrayList<String>(cNAME.size());
        cNAMECopy.addAll(cNAME);
        this.cNAME = cNAMECopy;
    }

    public DistributionConfig withCNAME(String ... cNAME) {
        if (this.getCNAME() == null) {
            this.setCNAME(new ArrayList<String>(cNAME.length));
        }
        for (String value : cNAME) {
            this.getCNAME().add(value);
        }
        return this;
    }

    public DistributionConfig withCNAME(Collection<String> cNAME) {
        if (cNAME == null) {
            this.cNAME = null;
        } else {
            ArrayList<String> cNAMECopy = new ArrayList<String>(cNAME.size());
            cNAMECopy.addAll(cNAME);
            this.cNAME = cNAMECopy;
        }
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public DistributionConfig withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DistributionConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public LoggingConfig getLogging() {
        return this.logging;
    }

    public void setLogging(LoggingConfig logging) {
        this.logging = logging;
    }

    public DistributionConfig withLogging(LoggingConfig logging) {
        this.logging = logging;
        return this;
    }

    public TrustedSigners getTrustedSigners() {
        return this.trustedSigners;
    }

    public void setTrustedSigners(TrustedSigners trustedSigners) {
        this.trustedSigners = trustedSigners;
    }

    public DistributionConfig withTrustedSigners(TrustedSigners trustedSigners) {
        this.trustedSigners = trustedSigners;
        return this;
    }

    public RequiredProtocols getRequiredProtocols() {
        return this.requiredProtocols;
    }

    public void setRequiredProtocols(RequiredProtocols requiredProtocols) {
        this.requiredProtocols = requiredProtocols;
    }

    public DistributionConfig withRequiredProtocols(RequiredProtocols requiredProtocols) {
        this.requiredProtocols = requiredProtocols;
        return this;
    }

    public String getDefaultRootObject() {
        return this.defaultRootObject;
    }

    public void setDefaultRootObject(String defaultRootObject) {
        this.defaultRootObject = defaultRootObject;
    }

    public DistributionConfig withDefaultRootObject(String defaultRootObject) {
        this.defaultRootObject = defaultRootObject;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.s3Origin != null) {
            sb.append("S3Origin: " + this.s3Origin + ", ");
        }
        if (this.customOrigin != null) {
            sb.append("CustomOrigin: " + this.customOrigin + ", ");
        }
        if (this.callerReference != null) {
            sb.append("CallerReference: " + this.callerReference + ", ");
        }
        if (this.cNAME != null) {
            sb.append("CNAME: " + this.cNAME + ", ");
        }
        if (this.comment != null) {
            sb.append("Comment: " + this.comment + ", ");
        }
        if (this.enabled != null) {
            sb.append("Enabled: " + this.enabled + ", ");
        }
        if (this.logging != null) {
            sb.append("Logging: " + this.logging + ", ");
        }
        if (this.trustedSigners != null) {
            sb.append("TrustedSigners: " + this.trustedSigners + ", ");
        }
        if (this.requiredProtocols != null) {
            sb.append("RequiredProtocols: " + this.requiredProtocols + ", ");
        }
        if (this.defaultRootObject != null) {
            sb.append("DefaultRootObject: " + this.defaultRootObject + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Origin() == null ? 0 : this.getS3Origin().hashCode());
        hashCode = 31 * hashCode + (this.getCustomOrigin() == null ? 0 : this.getCustomOrigin().hashCode());
        hashCode = 31 * hashCode + (this.getCallerReference() == null ? 0 : this.getCallerReference().hashCode());
        hashCode = 31 * hashCode + (this.getCNAME() == null ? 0 : ((Object)this.getCNAME()).hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.isEnabled() == null ? 0 : this.isEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getLogging() == null ? 0 : this.getLogging().hashCode());
        hashCode = 31 * hashCode + (this.getTrustedSigners() == null ? 0 : this.getTrustedSigners().hashCode());
        hashCode = 31 * hashCode + (this.getRequiredProtocols() == null ? 0 : this.getRequiredProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultRootObject() == null ? 0 : this.getDefaultRootObject().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfig)) {
            return false;
        }
        DistributionConfig other = (DistributionConfig)obj;
        if (other.getS3Origin() == null ^ this.getS3Origin() == null) {
            return false;
        }
        if (other.getS3Origin() != null && !other.getS3Origin().equals(this.getS3Origin())) {
            return false;
        }
        if (other.getCustomOrigin() == null ^ this.getCustomOrigin() == null) {
            return false;
        }
        if (other.getCustomOrigin() != null && !other.getCustomOrigin().equals(this.getCustomOrigin())) {
            return false;
        }
        if (other.getCallerReference() == null ^ this.getCallerReference() == null) {
            return false;
        }
        if (other.getCallerReference() != null && !other.getCallerReference().equals(this.getCallerReference())) {
            return false;
        }
        if (other.getCNAME() == null ^ this.getCNAME() == null) {
            return false;
        }
        if (other.getCNAME() != null && !((Object)other.getCNAME()).equals(this.getCNAME())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        if (other.isEnabled() != null && !other.isEnabled().equals(this.isEnabled())) {
            return false;
        }
        if (other.getLogging() == null ^ this.getLogging() == null) {
            return false;
        }
        if (other.getLogging() != null && !other.getLogging().equals(this.getLogging())) {
            return false;
        }
        if (other.getTrustedSigners() == null ^ this.getTrustedSigners() == null) {
            return false;
        }
        if (other.getTrustedSigners() != null && !other.getTrustedSigners().equals(this.getTrustedSigners())) {
            return false;
        }
        if (other.getRequiredProtocols() == null ^ this.getRequiredProtocols() == null) {
            return false;
        }
        if (other.getRequiredProtocols() != null && !other.getRequiredProtocols().equals(this.getRequiredProtocols())) {
            return false;
        }
        if (other.getDefaultRootObject() == null ^ this.getDefaultRootObject() == null) {
            return false;
        }
        return other.getDefaultRootObject() == null || other.getDefaultRootObject().equals(this.getDefaultRootObject());
    }
}

