% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_cdfs.R
\name{sp_cdf}
\alias{sp_cdf}
\title{Symmetric Power (SP) link CDF}
\usage{
sp_cdf(x, r, base, df = 8)
}
\arguments{
\item{x}{Numeric vector}

\item{r}{Power parameter (r > 0)}

\item{base}{Base distribution name}

\item{df}{Degrees of freedom (for tlink base)}
}
\value{
CDF values
}
\description{
The SP link applies a power transformation to a base CDF:
}
\details{
For r <= 1: F_sp(x) = F_0(x/r)^r
For r > 1:  F_sp(x) = 1 - F_0(-r*x)^(1/r)

Special case: r = 1 gives the base distribution F_0.

Reference: Li et al. (2019) Environmetrics
}
\keyword{internal}
