% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl.R
\name{tbl}
\alias{tbl}
\title{Create a table (tbl)}
\usage{
tbl(df,strata,vars,cols,tests = NA,digs = 2,digs_p = 3)
}
\arguments{
\item{df}{dataframe. (\code{df})}

\item{strata}{Column name of stratification (\code{string})}

\item{vars}{Column names of variables of interest (\code{list})}

\item{cols}{the methods on how to aggregate data (\code{list})}

\item{tests}{Tests - functional are 'wilcox', 'ttest', and 'auc' (\code{list})}

\item{digs}{digits in output (\code{numeric})}

\item{digs_p}{digits in output for p-values (\code{numeric})}
}
\value{
Returns summarised information in dataframe.
}
\description{
\code{tbl()} is a function which create a dataframe, which can be copied directly into
word or presented in as a summary table.
}
\examples{
\dontrun{
   hmm <- tbl1(df,strata="group",
      vars=c("WBC_renset","Ratio_WBC"),
      cols=c("No","Missing","median [IQR]"),
      tests=c("Wilcox.test","AUC"))
   knitr::kable(hmm)
}

}
