% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_titles_footnotes.R
\name{clin_add_titles}
\alias{clin_add_titles}
\alias{clin_add_footnotes}
\title{Add page footer}
\usage{
clin_add_titles(x, ls = NULL, ft = NULL)

clin_add_footnotes(x, ls = NULL, ft = NULL)
}
\arguments{
\item{x}{a clintable object}

\item{ls}{a list of character vectors, no more than 3 elements to a vector}

\item{ft}{A flextable object to use as the header}
}
\value{
A clintable object
}
\description{
This function adds a text, passed as argument, into .docx bottom colontitle (page footer). As a
result, the text is repeated on each page of the document. Takes a list of lists as an input parameter,
where each sublist represents a separate line (or row) of text. There is also a possibility to add a row
with both left- and right-aligned text. To do so - simply pass two items to a sublist instead of one.
}
\examples{
clintable(mtcars) |> 
  clin_add_titles(
    list(
      c("Left", "Center", "Right"),
      c("Just the middle")
    )
  ) |> 
  clin_add_footnotes(
    list(
      c(
        "Here's a footnote.", 
        format(Sys.time(), "\%H:\%M \%A, \%B \%d, \%Y")
      )
    )
  )

}
\concept{add_titles_footnotes}
