% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitPrintListObjects.R
\name{knitPrintListObjects}
\alias{knitPrintListObjects}
\title{Include a list of objects in a knitr document}
\usage{
knitPrintListObjects(
  xList,
  generalLabel = "objectsList",
  labels = paste0(generalLabel, seq_along(xList)),
  titles = NULL,
  titleLevel = 2,
  printObject = FALSE,
  ...
)
}
\arguments{
\item{xList}{List of objects to print.}

\item{generalLabel}{String with general label for the chunks, 
used to build the \code{labels}.
The labels are constructed as '\code{generalLabel}[i]',
with i the list index.
Only use if \code{labels} is not specified.}

\item{labels}{Character vector with labels,
one for each chunk.}

\item{titles}{Character vector with section titles,
one for each chunk.}

\item{titleLevel}{Integer with level for section header,
1 for top-level section header.}

\item{printObject}{Logical, if TRUE (FALSE by default),
each object within \code{xList} is explicitely printed 
with the \code{\link{print}} function.}

\item{...}{any chunk parameters, will be replicated if necessary,
at the exception of 'results', set to 'asis' and 'echo' set to FALSE
internally.
See \code{\link{knitr}[opts_chunk]} for further details on available options.}
}
\value{
No returned value, a text is printed with chunk content
}
\description{
This functions includes a list of objects in a knitr document 
allowing different chunk options
(e.g. \code{flextable} object).
}
\details{
Note: the chunk in which this function is called should be 
set with the following option: \strong{\code{results = 'asis'}}.
}
\examples{
\dontrun{

# Note: the following code should be included within a chunk of a knitr (e.g. RMarkdown) document
# to include/export a list of figures in the Rmarkdown output
data(iris)

# include a list of static plots
library(ggplot2)
plotsListStatic <- list(
	point = ggplot(data = cars, aes(x = speed, y = dist)) + geom_point(),
	line = ggplot(data = cars, aes(x = speed, y = dist)) + geom_line()
)
# with general label (used to name exported figure)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  generalLabel = "scatter-cars"
)
# with label for each plot (used to name exported figure)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  labels = names(plotsListStatic)
)
# with section header (header of level 1 in Markdown)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  titles = names(plotsListStatic), 
  titleLevel = 3
)
# specify caption and dimension for each figure (figure height is replicated)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  fig.cap = names(plotsListStatic), 
  fig.width = 3*seq_along(plotsListStatic), 
  fig.height = 6
)

# include a list of interactive plots
library(plotly)
plotsListInteractive <- list(
	point = plot_ly(data = cars, x = ~speed, y = ~dist, type = "scatter", mode = "marker"),
	line = plot_ly(data = cars, x = ~speed, y = ~dist, type = "scatter", mode = "line")
)
knitPrintListPlots(
 plotsList = plotsListInteractive, 
  type = "plotly", 
  titles = names(plotsListInteractive), 
  titleLevel = 3
)

}
\dontrun{
	
# Note: the following code should be included within a chunk of a knitr (e.g. RMarkdown) document
# to include/export a list of figures in the Rmarkdown output

# list of flextable objects
library(flextable)
listTables <- list(flextable(iris), flextable(cars))
knitPrintListObjects(xList = listTables)

}
}
\author{
Laure Cougnaud
}
