% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-general.R
\name{checkChapterParallel}
\alias{checkChapterParallel}
\title{Check if a chapter is run internally in parallel or not.}
\usage{
checkChapterParallel(
  configFile,
  configDir = file.path(inputDir, "config"),
  inputDir = "."
)
}
\arguments{
\item{configFile}{String with filename of the config
file of interest in YAML format.}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{inputDir}{String with input directory,
working directory by default.}
}
\value{
Logical, if TRUE, the chapter is run in parallel
(FALSE if not available).
}
\description{
This is identified via the 'parallel' parameter from the config file.
If this parameter is not available in the config file 
(or the parameters are imported with an error), the chapter is 
considered to not be run in parallel.
}
