% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-boxplotClinData.R
\name{addFacetPanel}
\alias{addFacetPanel}
\title{Add facet-panel to single plotly plot.}
\usage{
addFacetPanel(
  pl,
  panelLab,
  panelWidth = 20,
  fontSize = 15,
  side = c("top", "right")
)
}
\arguments{
\item{pl}{a plotly object to which to add a single facet panel}

\item{panelLab}{text to be shown in the facet panel}

\item{panelWidth}{thickness of the panel in pixels.}

\item{fontSize}{fontsize of \code{facetText}}

\item{side}{the side of the plot to show the panel 
(currently only right panels are implemented.)}
}
\value{
plotly object with the facet panel added.
}
\description{
Add facet-panel to single plotly plot.
}
\details{
plot title clipping.

Incase case side = 'top', the plot title (eg. layout(title = "title"))
will clip with the top pannel. 

Resolve this with the following configutations: (once all the subplots have already been combined)
\code{
layout(
		title = list(text = "title", yref = "container", y = 1)) # place the title at absolute top of the page
		margin = list(t = panelWidth + heightTitleTextInPixels) # If font size = 15 roughly equal to 20 pixels. 
}
}
\author{
lennart tuijnder
}
