% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clima_data.R
\docType{data}
\name{clima_data}
\alias{clima_data}
\alias{lonlatsf}
\alias{temp_dat}
\alias{rain_dat}
\alias{innlandet}
\title{Example of input data using local data}
\format{
an array with two layers (temp_dat) a matrix (rain_dat), an sf object (lonlatsf)
}
\source{
Funk, C. et al. (2015). The climate hazards infrared precipitation 
with stations—a new environmental record for monitoring extremes. 
Scientific Data, 2, 150066. \url{https://doi.org/10.1038/sdata.2015.66}

Wan Z, Hook S, Hulley G (2015) MYD11A1 MODIS/Aqua Land Surface 
Temperature/Emissivity 8-Day L3 Global 1km
SIN Grid V006 \url{http://dx.doi.org/10.5067/MODIS/MYD11A2.006}.
}
\description{
Input example from disk data. See details
}
\details{
\code{temp_dat}: array with two layers 1) day temperature and 2) night temperature. 
 An excerpt of MODIS (MYD11A1) data to represent an example 
 of the input data in \code{temperature()} and \code{get_timeseries()} 
 when an array is provided.

\code{rain_dat}: matrix with precipitation from CHIRPS. An excerpt to represent 
 an example of the input data in \code{rainfall()} or 
 \code{get_timeseries()} when a matrix is provided.
 
\code{innlandet}: matrix with maximum and minimum temperature for a random point in 
 the Innlandet county in Norway, spanning from "2019-01-01" to "2019-07-01"
 
\code{innlandet}: matrix with maximum and minimum temperature for a random point in 
 the Innlandet county in Norway, spanning from "2019-01-01" to "2019-07-01"
 
\code{lonlatsf}: a 'sf' object with 'POINT' geometry with five random points around 
 Sinop, Brazil 
 
In \code{temp_dat} and \code{rain_dat}, rows represents the coordinates for the 
 given lonlat provided in \code{raster::extract()} and colunms represents the dates 
 from the observed precipitation/temperature.
}
\keyword{datasets}
