% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive.R
\name{mine.plot}
\alias{mine.plot}
\title{Mine plot}
\usage{
mine.plot(
  x,
  what = "is.na(x)",
  spacing = 5,
  sort = F,
  list = FALSE,
  show.x = TRUE,
  show.y = TRUE,
  ...
)
}
\arguments{
\item{x}{A data.frame}

\item{what}{A logical expresion that will be depicted in the plot}

\item{spacing}{Numerical separation between lines at the y-axis}

\item{sort}{If TRUE, variables are sorted according to their results}

\item{list}{If TRUE, creates a vector with the results}

\item{show.x}{Should the x-axis be plotted?}

\item{show.y}{Should the y-axis be plotted?}

\item{...}{further arguments passed to order()}
}
\description{
Creates a heatmap-like plot for exploring the data
}
\examples{
mine.plot(airquality)   #Displays missing data
mine.plot(airquality, what="x>mean(x)+2*sd(x) | x<mean(x)-2*sd(x)")   #Shows extreme values
}
