% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.cle.ord.repar.R
\name{func.cl.ord.repar}
\alias{func.cl.ord.repar}
\title{Reparameterized Composite Likelihood Calculation for Spatial Ordinal Data}
\usage{
func.cl.ord.repar(vec.yobs, mat.X, mat.lattice, radius, n.cat, vec.repar)
}
\arguments{
\item{vec.yobs}{a vector of observed responses for all N sites.}

\item{mat.X}{regression (design) matrix, including intercepts.}

\item{mat.lattice}{a data matrix containing geographical information of sites. The \emph{i} th row constitutes a set of geographical coordinates.}

\item{radius}{weight radius.}

\item{n.cat}{number of categories, at least 2.}

\item{vec.repar}{a vector of parameters consecutively as follows: a reparameterized vector (tau's) for latent responses, a vector of covariate parameters, a parameter 'sigmasq' modeling covariance matrix, 0<=sigmasq<=1, and a parameter 'rho' reflecting spatial correlation, abs(rho)<=1.}
}
\value{
\code{func.cl.ord} returns a list: number of categories, sum of weights, composite log-likelihood, a vector of scores, and a matrix of first-order partial derivatives for \code{vec.par}.
}
\description{
\code{func.cl.ord} calculates the composite log-likelihood for reparameterized spatial ordered probit models. This function is internally called by \code{func.cle.ord}.
}
\references{
Feng, Xiaoping, Zhu, Jun, Lin, Pei-Sheng, and Steen-Adams, Michelle M. (2014) Composite likelihood Estimation for Models of Spatial Ordinal Data and Spatial Proportional Data with Zero/One values. \emph{Environmetrics} 25(8): 571--583.
}
