% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/group_update.R
\name{group_update}
\alias{group_update}
\title{Update a group}
\usage{
group_update(x, id, url = get_default_url(), key = get_default_key(),
  as = "list", ...)
}
\arguments{
\item{x}{(list) A list with key-value pairs}

\item{id}{(character) Package identifier}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Update a group
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org/", key = getOption("ckan_demo_key"))

# First, create a group
grp <- group_create("water-bears2")
group_show(grp)

## update just chosen things
# Make some changes
x <- list(description = "A group about water bears and people that love them")

# Then update the packge
group_update(x, id = grp)
}
}

