% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_filter.R
\name{cja_get_filter}
\alias{cja_get_filter}
\title{Get a filter in CJA}
\usage{
cja_get_filter(
  id = NULL,
  toBeUsedInRsid = NULL,
  locale = "en_US",
  expansion = "definition",
  debug = FALSE
)
}
\arguments{
\item{id}{The filter id to retrieve}

\item{toBeUsedInRsid}{The data view where the filter is intended to be used.
This data view will be used to determine things like compatibility and permissions.}

\item{locale}{Locale - Default: "en_US"}

\item{expansion}{Comma-delimited list of additional filter metadata fields to
include on response. See Details for all options available}

\item{debug}{Used to help troubleshoot api call issues. Shows the call and result in the console}
}
\value{
A filter list
}
\description{
Retrieves a specific filter, also known as a \code{segment} in Adobe Analytics.
}
\details{
\emph{Expansion} options can include the following:
"compatibility", "definition", "internal", "modified", "isDeleted", "definitionLastModified",
"createdDate", "recentRecordedAccess", "performanceScore", "owner", "dataId",
"ownerFullName", "dataName", "sharesFullName", "approved", "favorite", "shares",
"tags", "usageSummary", "usageSummaryWithRelevancyScore"
}
\examples{
\dontrun{
cja_get_filter()
}
}
