% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{projects_list}
\alias{projects_list}
\title{List projects}
\usage{
projects_list(author = NULL, permission = NULL, hidden = NULL,
  archived = NULL, limit = NULL, page_num = NULL, order = NULL,
  order_dir = NULL)
}
\arguments{
\item{author}{string optional. If specified, return projects owned by this author. It accepts a comma-separated list of author ids.}

\item{permission}{string optional. A permissions string, one of "read", "write", or "manage". Lists only projects for which the current user has that permission.}

\item{hidden}{boolean optional. If specified to be true, returns hidden objects. Defaults to false, returning non-hidden objects.}

\item{archived}{string optional. The archival status of the requested object(s).}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for this project.}
\item{author}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{name}{string, The name of this project.}
\item{description}{string, A description of the project}
\item{users}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{autoShare}{boolean, }
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{archived}{string, The archival status of the requested object(s).}
}
\description{
List projects
}
