% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_patch_containers}
\alias{scripts_patch_containers}
\title{Update a container}
\usage{
scripts_patch_containers(id, name = NULL, parent_id = NULL,
  user_context = NULL, params = NULL, arguments = NULL, schedule = NULL,
  notifications = NULL, required_resources = NULL, repo_http_uri = NULL,
  repo_ref = NULL, remote_host_credential_id = NULL,
  git_credential_id = NULL, docker_command = NULL,
  docker_image_name = NULL, docker_image_tag = NULL,
  cancel_timeout = NULL, time_zone = NULL, target_project_id = NULL)
}
\arguments{
\item{id}{integer required. The ID for the script.}

\item{name}{string optional. The name of the container.}

\item{parent_id}{integer optional. The ID of the parent job that will trigger this script}

\item{user_context}{string optional. "runner" or "author", who to execute the script as when run as a template.}

\item{params}{array optional. An array containing the following fields: 
\itemize{
\item name string, The variable's name as used within your code.
\item label string, The label to present to users when asking them for the value.
\item description string, A short sentence or fragment describing this parameter to the end user.
\item type string, The type of parameter. Valid options: string, multi_line_string, integer, float, bool, file, database, credential_aws, credential_redshift, or credential_custom
\item required boolean, Whether this param is required.
\item value string, The value you would like to set this param to. Setting this value makes this parameter a fixed param.
\item default string, If an argument for this parameter is not defined, it will use this default value. Use true, True, t, y, yes, or 1 for true bool's or false, False, f, n, no, or 0 for false bool's. Cannot be used for parameters that are required or a credential type.
\item allowedValues array, The possible values this parameter can take, effectively making this an enumerable parameter. Allowed values is an array of hashes of the following format: `{label: 'Import', 'value': 'import'}`
}}

\item{arguments}{object optional. Dictionary of name/value pairs to use to run this script. Only settable if this script has defined params.}

\item{schedule}{object optional. A list containing the following elements: 
\itemize{
\item scheduled boolean, If the object is scheduled
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday
\item scheduledHours array, Hours of the day it is scheduled on
\item scheduledMinutes array, Minutes of the day it is scheduled on
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour
}}

\item{notifications}{object optional. A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}

\item{required_resources}{object optional. A list containing the following elements: 
\itemize{
\item cpu integer, The number of CPU shares to allocate for the container. Each core has 1024 shares.
\item memory integer, The amount of RAM to allocate for the container (in MiB).
\item diskSpace number, The amount of disk space, in GB, to allocate for the container. This space will be used to hold the git repo configured for the container and anything your container writes to /tmp or /data. Fractional values (e.g. 0.25) are supported.
}}

\item{repo_http_uri}{string optional. The location of a github repo to clone into the container, e.g. github.com/my-user/my-repo.git.}

\item{repo_ref}{string optional. The tag or branch of the github repo to clone into the container.}

\item{remote_host_credential_id}{integer optional. The id of the database credentials to pass into the environment of the container.}

\item{git_credential_id}{integer optional. The id of the git credential to be used when checking out the specified git repo. If not supplied, the first git credential you've submitted will be used. Unnecessary if no git repo is specified or the git repo is public.}

\item{docker_command}{string optional. The command to run on the container. Will be run via sh as: ["sh", "-c", dockerCommand]}

\item{docker_image_name}{string optional. The name of the docker image to pull from DockerHub.}

\item{docker_image_tag}{string optional. The tag of the docker image to pull from DockerHub (default: latest).}

\item{cancel_timeout}{integer optional. The amount of time (in seconds) to wait before forcibly terminating the script. When the script is cancelled, it is first sent a TERM signal. If the script is still running after the timeout, it is sent a KILL signal. Defaults to 0.}

\item{time_zone}{string optional. The time zone of this script.}

\item{target_project_id}{integer optional. Target project to which script outputs will be added.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the script.}
\item{name}{string, The name of the container.}
\item{type}{string, The type of the script (e.g Container)}
\item{createdAt}{string, The time this script was created.}
\item{updatedAt}{string, The time the script was last updated.}
\item{author}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the script's last run.}
\item{finishedAt}{string, The time that the script's last run finished.}
\item{category}{string, The category of the script.}
\item{projects}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID for the project.
\item name string, The name of the project.
}}
\item{parentId}{integer, The ID of the parent job that will trigger this script}
\item{userContext}{string, "runner" or "author", who to execute the script as when run as a template.}
\item{params}{array, An array containing the following fields: 
\itemize{
\item name string, The variable's name as used within your code.
\item label string, The label to present to users when asking them for the value.
\item description string, A short sentence or fragment describing this parameter to the end user.
\item type string, The type of parameter. Valid options: string, multi_line_string, integer, float, bool, file, database, credential_aws, credential_redshift, or credential_custom
\item required boolean, Whether this param is required.
\item value string, The value you would like to set this param to. Setting this value makes this parameter a fixed param.
\item default string, If an argument for this parameter is not defined, it will use this default value. Use true, True, t, y, yes, or 1 for true bool's or false, False, f, n, no, or 0 for false bool's. Cannot be used for parameters that are required or a credential type.
\item allowedValues array, The possible values this parameter can take, effectively making this an enumerable parameter. Allowed values is an array of hashes of the following format: `{label: 'Import', 'value': 'import'}`
}}
\item{arguments}{object, Dictionary of name/value pairs to use to run this script. Only settable if this script has defined params.}
\item{isTemplate}{boolean, Whether others scripts use this one as a template.}
\item{templateDependentsCount}{integer, How many other scripts use this one as a template.}
\item{publishedAsTemplateId}{integer, The ID of the template that this script is backing.}
\item{fromTemplateId}{integer, The ID of the template script.}
\item{templateScriptName}{string, The name of the template script.}
\item{links}{object, A list containing the following elements: 
\itemize{
\item details string, The details link to get more information about the script.
\item runs string, The runs link to get the run information list for this script.
}}
\item{schedule}{object, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the object is scheduled
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday
\item scheduledHours array, Hours of the day it is scheduled on
\item scheduledMinutes array, Minutes of the day it is scheduled on
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour
}}
\item{notifications}{object, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}
\item{runningAs}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{requiredResources}{object, A list containing the following elements: 
\itemize{
\item cpu integer, The number of CPU shares to allocate for the container. Each core has 1024 shares.
\item memory integer, The amount of RAM to allocate for the container (in MiB).
\item diskSpace number, The amount of disk space, in GB, to allocate for the container. This space will be used to hold the git repo configured for the container and anything your container writes to /tmp or /data. Fractional values (e.g. 0.25) are supported.
}}
\item{repoHttpUri}{string, The location of a github repo to clone into the container, e.g. github.com/my-user/my-repo.git.}
\item{repoRef}{string, The tag or branch of the github repo to clone into the container.}
\item{remoteHostCredentialId}{integer, The id of the database credentials to pass into the environment of the container.}
\item{gitCredentialId}{integer, The id of the git credential to be used when checking out the specified git repo. If not supplied, the first git credential you've submitted will be used. Unnecessary if no git repo is specified or the git repo is public.}
\item{dockerCommand}{string, The command to run on the container. Will be run via sh as: ["sh", "-c", dockerCommand]}
\item{dockerImageName}{string, The name of the docker image to pull from DockerHub.}
\item{dockerImageTag}{string, The tag of the docker image to pull from DockerHub (default: latest).}
\item{cancelTimeout}{integer, The amount of time (in seconds) to wait before forcibly terminating the script. When the script is cancelled, it is first sent a TERM signal. If the script is still running after the timeout, it is sent a KILL signal. Defaults to 0.}
\item{lastRun}{object, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{timeZone}{string, The time zone of this script.}
\item{hidden}{boolean, The hidden status of the object.}
\item{archived}{string, The archival status of the requested object(s).}
\item{targetProjectId}{integer, Target project to which script outputs will be added.}
}
\description{
Update a container
}
