% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{models_put_predictions}
\alias{models_put_predictions}
\title{Add a table on which to apply the predictive model}
\usage{
models_put_predictions(id, table_name, primary_key, limiting_sql = NULL,
  output_table = NULL, schedule = NULL)
}
\arguments{
\item{id}{integer required. The ID of the model to which to apply the prediction.}

\item{table_name}{string required. The qualified name of the table on which to apply the predictive model.}

\item{primary_key}{array required. The primary key or composite keys of the table being predicted.}

\item{limiting_sql}{string optional. A SQL WHERE clause used to scope the rows to be predicted.}

\item{output_table}{string optional. The qualified name of the table to be created which will contain the model's predictions.}

\item{schedule}{object optional. A list containing the following elements: 
\itemize{
\item scheduled boolean, If the object is scheduled
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday
\item scheduledHours array, Hours of the day it is scheduled on
\item scheduledMinutes array, Minutes of the day it is scheduled on
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour
}}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the model to which to apply the prediction.}
\item{tableName}{string, The qualified name of the table on which to apply the predictive model.}
\item{primaryKey}{array, The primary key or composite keys of the table being predicted.}
\item{limitingSQL}{string, A SQL WHERE clause used to scope the rows to be predicted.}
\item{outputTable}{string, The qualified name of the table to be created which will contain the model's predictions.}
\item{schedule}{object, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the object is scheduled
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday
\item scheduledHours array, Hours of the day it is scheduled on
\item scheduledMinutes array, Minutes of the day it is scheduled on
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour
}}
\item{state}{string, The status of the prediction. One of: "succeeded", "failed", "queued", or "running,"or "idle", if no build has been attempted.}
}
\description{
Add a table on which to apply the predictive model
}
