% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplineML.R
\name{SplineML}
\alias{SplineML}
\title{Spline ML fitting}
\usage{
SplineML(
  excesses,
  drc,
  thetaVec = 0:360,
  nBoot = 100,
  numIntKnots = 10,
  knotsType = "eqSpaced",
  lambda = seq(0, 2, by = 0.5),
  kappa = seq(0, 2, by = 0.5),
  nCandidatesInit = 1000,
  numCores = 2
)
}
\arguments{
\item{excesses}{Excesses data}

\item{drc}{Directional covariate}

\item{thetaVec}{Grid values at which the threshold will be evaluated}

\item{nBoot}{Number of bootstrap resamples}

\item{numIntKnots}{Number of internal knots}

\item{knotsType}{Position of knots. Default to "eqSpaced". Otherwise, the
knots will be placed at the quantiles of observed directions.}

\item{lambda}{Penalty parameter values for lambda}

\item{kappa}{Penalty parameter values for kappa}

\item{nCandidatesInit}{Number of initial parameter vectors.
Optimisation will start with the best.}

\item{numCores}{Number of CPU cores to be used}
}
\value{
List of bootstrap estimates of shape and scale, and optimal values of lambda and kappa.
}
\description{
Spline ML fitting
}
\details{
See Konzen, E., Neves, C., and Jonathan, P. (2020+). Modelling non-stationary extremes of storm severity: comparing parametric and semi-parametric inference. Environmetrics (to appear).
}
\examples{
data(HsSP)
data(drc)
timeRange <- 54.5

idx <- order(drc)
drc <- drc[idx]
Data <- HsSP[idx]
set.seed(1234)
Data <- Data + runif(length(Data), -1e-4, 1e-4)

thetaVec <- 1:360

data(thresholdExampleML) # loads threshold example
thrResultML <- thresholdExampleML

lambda <- 100
kappa <- 40

thrPerObs <- thrResultML[drc]
excess <- Data - thrPerObs
drcExcess <- drc[excess>0]
excess <- excess[excess>0]

\donttest{

splineFit <- SplineML(excesses = excess, drc = drcExcess, nBoot = 30,
                      numIntKnots = 16, lambda=lambda, kappa=kappa, numCores=2)

xiBoot <- splineFit$xi
sigBoot <- splineFit$sig

PlotParamEstim(bootEstimates=xiBoot, thetaGrid=0:360, ylab=bquote(hat(xi)),
               alpha=0.05, ylim=NULL, cex.axis=15, cex.lab=2, thrWidth=2)

PlotParamEstim(bootEstimates=sigBoot, thetaGrid=0:360, ylab=bquote(hat(sigma)),
               alpha=0.05, ylim=NULL, cex.axis=15, cex.lab=2, thrWidth=2)

h <- 60 # needed for calculating local probability of exceedances
RLBoot <- CalcRLsplineML(Data=Data, drc=drc, xiBoot=xiBoot, sigBoot=sigBoot, h=h,
                         TTs=c(100, 10000), thetaGrid=thetaVec,
                         timeRange=timeRange, thr=thrResultML)

# 100-year level
PlotRL(RLBootList=RLBoot, thetaGrid=thetaVec, Data=Data, drc=drc,
       TTs=c(100, 10000), whichPlot=1, alpha=0.05, ylim=NULL,
       pointSize=1, cex.axis=15, cex.lab=2, thrWidth=2)

PolarPlotRL(RLBootList=RLBoot, thetaGrid=thetaVec, Data=Data, drc=drc,
            TTs=c(100, 10000), whichPlot=1, alpha=0.05, ylim=c(0, 25),
            pointSize=4, fontSize=12, lineWidth=2)

}

## See also examples in vignette:
# vignette("splineML", package = "circularEV")
}
