% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccYaxis}
\alias{ccYaxis}
\title{Draw y-axis}
\usage{
ccYaxis(
  side = c("left", "right"),
  at = NULL,
  labels = TRUE,
  tick = TRUE,
  labels.font = par("font"),
  labels.cex = par("cex"),
  labels.niceFacing = TRUE,
  lwd = par("lwd"),
  col = par("col"),
  labels.col = par("col")
)
}
\arguments{
\item{side}{add the y-axis on the left or right of the cell}

\item{at}{If it is numeric vector, it identifies the positions of the ticks. It can exceed \code{ylim} value and the exceeding part would be trimmed automatically.}

\item{labels}{labels of the ticks. The exceeding part would be trimmed automatically. The value can also be logical (either an atomic value or a vector) which represents which labels to show.}

\item{tick}{Whether to draw ticks.}

\item{labels.font}{font style for the axis labels}

\item{labels.cex}{font size for the axis labels}

\item{labels.niceFacing}{Should facing of axis labels be human-easy}

\item{lwd}{line width for ticks}

\item{col}{color for the axes}

\item{labels.col}{color for the labels}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.yaxis]{circlize::circos.yaxis} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:8], xlim = c(0, 1))
track <- ccTrack(ylim = c(0, 10))
cell <- ccCell(sector.index = "a") + ccYaxis(side = "left")
track <- track + cell
cc + track
}
