% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_xifti.R
\name{remove_xifti}
\alias{remove_xifti}
\title{Remove a component from a \code{"xifti"}}
\usage{
remove_xifti(xifti, remove = NULL)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{remove}{A character vector containing one or more of the following:
\code{"cortex_left"}, \code{"cortex_right"}, \code{"subcortical"},
\code{"surf_left"}, and \code{"surf_right"}. Each of these components will
be removed from the \code{"xifti"}}
}
\value{
The new \code{"xifti"} with the requested component(s) removed
}
\description{
Remove a brain structure or surface from a \code{"xifti"}
}
\seealso{
Other functions for manipulating `xifti` objects: 
\code{\link{add_surf}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{newdata_xifti}()},
\code{\link{select_xifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating}
