% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.xifti.R
\name{is.cifti}
\alias{is.cifti}
\alias{is_cifti}
\alias{isCIfTI}
\title{Validate a \code{"xifti"} object}
\usage{
is.cifti(x, messages = TRUE)

is_cifti(x, messages = TRUE)

isCIfTI(x, messages = TRUE)
}
\arguments{
\item{x}{The putative \code{"xifti"}.}

\item{messages}{If \code{x} is not a \code{"xifti"}, print messages
explaining the problem? Default is \code{TRUE}.}
}
\value{
Logical. Is \code{x} a valid \code{"xifti"}?
}
\description{
Check if object is valid for a \code{"xifti"}. This alias for
\code{\link{is.xifti}} is offered as a convenience, and a message will warn
the user. We recommend using \code{\link{is.xifti}} instead.
}
\details{
Requirements: it is a list with the same structure as
\code{\link{template_xifti}}. The size of each data entry must be
compatible with its corresponding mask (medial wall for the cortex and
volumetric mask for the subcortex). Metadata should be present if and only
if the corresponding data is also present. The surfaces can be present
whether or not the cortex data are present.

See the "Label Levels" section for the requirements of
\code{xifti$meta$subcort$labels}.
}
\section{Label Levels}{

\code{xifti$meta$subcort$labels} is a factor with the following levels:

\enumerate{
\item{Cortex-L}
\item{Cortex-R}
\item{Accumbens-L}
\item{Accumbens-R}
\item{Amygdala-L}
\item{Amygdala-R}
\item{Brain Stem}
\item{Caudate-L}
\item{Caudate-R}
\item{Cerebellum-L}
\item{Cerebellum-R}
\item{Diencephalon-L}
\item{Diencephalon-R}
\item{Hippocampus-L}
\item{Hippocampus-R}
\item{Pallidum-L}
\item{Pallidum-R}
\item{Putamen-L}
\item{Putamen-R}
\item{Thalamus-L}
\item{Thalamus-R}
}

These correspond to the same structures as given by
\code{ft_read_cifti} in the \code{cifti-matlab} MATLAB toolbox. Note that
the first two levels (left and right cortex) are not used.
}

\seealso{
Other commonly-used functions: 
\code{\link{read_cifti}()},
\code{\link{resample_cifti}()},
\code{\link{smooth_cifti}()},
\code{\link{view_xifti_surface}()},
\code{\link{view_xifti_volume}()},
\code{\link{write_cifti}()}
}
\concept{common}
