% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_RR_logit.R
\name{avg_RR_logit}
\alias{avg_RR_logit}
\title{An Average of the Log Odds Ratio}
\usage{
avg_RR_logit(y, t, x, w = "control")
}
\arguments{
\item{y}{n-dimensional vector of binary outcomes}

\item{t}{n-dimensional vector of binary treatments}

\item{x}{n by d matrix of covariates}

\item{w}{'case' if the average is conditional on the case sample; 'control' if it is conditional on the control sample
default w =  'control'}
}
\value{
An S3 object of type "ciccr". The object has the following elements.
\item{est}{a scalar estimate of the weighted average of the log odds ratio using retrospective logistic regression}
\item{se}{standard error}
}
\description{
Averages the log odds ratio using retrospective logistic regression.
}
\examples{
# use the ACS_CC dataset included in the package
  y = ciccr::ACS_CC$topincome
  t = ciccr::ACS_CC$baplus
  x = ciccr::ACS_CC$age
# use 'case' to condition on the distribution of covariates given y = 1
  results = avg_RR_logit(y, t, x, 'case')

}
\references{
Jun, S.J. and Lee, S. (2020). Causal Inference in Case-Control Studies.
\url{https://arxiv.org/abs/2004.08318}.
}
