% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XArray-subset.R
\name{subset,XArray-method}
\alias{subset,XArray-method}
\title{Subset a \code{\link{RasterArray}} or \code{\link{SpatialArray}} object}
\usage{
\S4method{subset}{XArray}(x, i, j, ..., oneDim = FALSE, drop = TRUE)
}
\arguments{
\item{x}{\code{\link{RasterArray}} or \code{\link{SpatialArray}} object.}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{j}{subscript of the second dimension (columns).}

\item{...}{subscript of additional dimensions.}

\item{oneDim}{\code{logical} In case of multidimensional \code{\link{RasterArray}}s or \code{\link{SpatialArray}}s, setting \code{oneDim} to \code{TRUE} allows the application of one dimensional subscripts.}

\item{drop}{\code{logical} in case the result of subsetting is a single element, should the \\code{\link{RasterArray}} or \code{\link{SpatialArray}} wrapper be dropped and the element be reduced to a single \code{RasterLayer}/ \code{Spatial*} object?}
}
\value{
A \code{RasterLayer}, \code{RasterArray}, \code{Spatial*} or \code{\link{SpatialArray}} class object.
}
\description{
Extract subsets of \code{\link{RasterArray}} or \code{\link{SpatialArray}} class object similarly to a regular array.
}
\examples{
data(dems)
# first 4
subset(dems, i=1:4)
# missing at the end
subset(dems, i=1:12)
# character subscript
subset(dems, i=c("5", "25"))
# logical subscript
subs <- rep(TRUE, length(dems))
subs[1] <- FALSE # remove first
subset(dems, i= subs)
# no drop
subset(dems, i=1, drop=FALSE)
data(coasts)
subset(coasts, i=2, j=1:2)
}
