% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronicle.R
\name{check_diff}
\alias{check_diff}
\title{Check the output of the diff column}
\usage{
check_diff(.c, columns = c("ops_number", "function"))
}
\arguments{
\item{.c}{A chronicle object.}

\item{columns}{Columns to select for the output. Defaults to c("ops_number", "function").}
}
\value{
A data.frame with the selected columns and column "diff_obj".
}
\description{
Check the output of the diff column
}
\details{
`diff` is an option argument to the `record()` function. When `diff` = "full",
a diff of the input and output of the decorated function gets saved, and if
`diff` = "summary" only a summary of the diff is saved.
}
\examples{
r_subset <- record(subset, diff = "full")
result <- r_subset(mtcars, select = am)
check_diff(result) # <- this is the data frame listing the operations and the accompanying diffs
check_diff(result)$diff_obj # <- actually look at the diffs
}
