% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country.R
\name{country_choropleth}
\alias{country_choropleth}
\title{Create a country-level choropleth}
\usage{
country_choropleth(df, title = "", legend = "", num_colors = 7,
  zoom = NULL)
}
\arguments{
\item{df}{A data.frame with a column named "region" and a column named "value".  Elements in 
the "region" column must exactly match how regions are named in the "region" column in ?country.map.}

\item{title}{An optional title for the map.}

\item{legend}{An optional name for the legend.}

\item{num_colors}{The number of colors to use on the map.  A value of 0 uses 
a divergent scale (useful for visualizing negative and positive numbers), A 
value of 1 uses a continuous scale (useful for visualizing outliers), and a 
value in [2, 9] will use that many quantiles.}

\item{zoom}{An optional vector of countries to zoom in on. Elements of this vector must exactly 
match the names of countries as they appear in the "region" column of ?country.regions}
}
\description{
The map used is country.map in the choroplethrMaps package. See country.regions for
an object which can help you coerce your regions into the required format.
}
\examples{
# demonstrate default options
data(df_pop_country)
country_choropleth(df_pop_country, "2012 World Bank Populate Estimates")

# demonstrate continuous scale
country_choropleth(df_pop_country, "2012 World Bank Populate Estimates", num_colors=1)

# demonstrate zooming
country_choropleth(df_pop_country, 
                   "2012 World Bank Population Estimates", 
                   num_colors=1,
                   zoom=c("united states of america", "canada", "mexico"))
}
