# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' The Chopthin Resampler
#'
#' A fast implementation of the Chopthin resampler. Can be used as the
#' resampling step in particle filters and in sequential Monte Carlo.
#'
#' @param w a vector of weights
#' @param N target number of particles
#' @param eta upper bound on the ratio between the weights. Must be >=4.
#' @return A list with two elements: new weights and indices 
#' of the ancestors of the new particles. The weights are normalised to add up to N.
#'
#' @references
#' A Gandy and F. D-H Lau. The chopthin algorithm for 
#' resampling. arXiv:1502.07532 [stat.CO], 2015
#' 
#' @examples
#' chopthin(runif(10),N=10)
#' chopthin(runif(10),N=20,4)
#' chopthin(runif(10),N=5)
#' chopthin(runif(10),N=1)
#' @export
chopthin <- function(w, N, eta = 5.828427) {
    .Call('chopthin_chopthin', PACKAGE = 'chopthin', w, N, eta)
}

