% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhoodWalking.R
\name{addNeighborhoodWalking}
\alias{addNeighborhoodWalking}
\title{Add walking neighborhoods.}
\usage{
addNeighborhoodWalking(pump.select = NULL, vestry = FALSE,
  weighted = TRUE, case.set = "expected", latlong = FALSE,
  type = "area.polygons", tsp.method = "repetitive_nn", path.width = 2,
  alpha.level = 0.5, polygon.type = "solid", polygon.col = NULL,
  polygon.lwd = 2, multi.core = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps. Note that you can't just select the pump on Adam and Eve Court (#2) because it's technically an isolate.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest path weighted by road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{case.set}{Character. "observed", "expected" or "snow". "snow" captures John Snow's annotation of the Broad Street pump neighborhood printed in the Vestry report version of the map.}

\item{latlong}{Logical.}

\item{type}{Character. "roads", "area.points" or "area.polygons". "area" flavors only valid when \code{case.set = "expected"}.}

\item{tsp.method}{Character. Traveling salesperson problem algorithm.}

\item{path.width}{Numeric. Set width of paths.}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{polygon.type}{Character. "border" or "solid".}

\item{polygon.col}{Character.}

\item{polygon.lwd}{Numeric.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. See \code{vignette("Parallelization")} for details.}
}
\description{
Add walking neighborhoods.
}
\examples{
\dontrun{
streetNameLocator("marshall street", zoom = 0.5)
addNeighborhoodWalking()
}
}
