% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walkingPath.R
\name{plot.walking_path}
\alias{plot.walking_path}
\title{Plot the walking path between selected cases and/or pumps.}
\usage{
\method{plot}{walking_path}(x, zoom = 0.5, unit.posts = "distance",
  unit.interval = NULL, alpha.level = 1, ...)
}
\arguments{
\item{x}{An object of class "walking_path" created by walkingPath().}

\item{zoom}{Logical or Numeric. A numeric value >= 0 controls the degree of zoom. The default is 0.5.}

\item{unit.posts}{Character. "distance" for mileposts; "time" for timeposts; NULL for no posts.}

\item{unit.interval}{Numeric. Set interval between posts. When \code{unit.posts = "distance"}, \code{unit.interval} defaults to 50 meters. When \code{unit.posts = "time"}, \code{unit.interval} defaults to 60 seconds.}

\item{alpha.level}{Numeric. Alpha level transparency for path: a value in [0, 1].}

\item{...}{Additional plotting parameters.}
}
\value{
A base R plot.
}
\description{
Plot the walking path between selected cases and/or pumps.
}
\section{Note}{
 Arrows represent mileposts or timeposts to the destination.
}

\examples{
\donttest{
plot(walkingPath(15))
plot(walkingPath(15), unit.posts = "time")
}
}
