% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walking.R
\name{neighborhoodWalking}
\alias{neighborhoodWalking}
\title{Compute walking path pump neighborhoods.}
\usage{
neighborhoodWalking(pump.select = NULL, vestry = FALSE,
  weighted = TRUE, case.set = "observed", multi.core = FALSE,
  dev.mode = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps. Note that you can't just select the pump on Adam and Eve Court (#2) because it's technically an isolate.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest path weighted by road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{case.set}{Character. "observed", "expected" or "snow". "snow" captures John Snow's annotation of the Broad Street pump neighborhood printed in the Vestry report version of the map.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. See \code{vignette("Parallelization")} for details.}

\item{dev.mode}{Logical. Development mode uses parallel::parLapply().}
}
\value{
An R list with 7 objects:
\itemize{
  \item{\code{paths}: list of paths to nearest or selected pump(s).}
  \item{\code{cases}: list of cases by pump.}
  \item{\code{vestry}: "vestry" from neighborhoodWalking().}
  \item{\code{observed}: "observed" from neighborhoodWalking().}
  \item{\code{pump.select}: "pump.select" from neighborhoodWalking().}
  \item{\code{cores}: number of cores to use for parallel implementation.}
  \item{\code{metric}: incremental metric used to find cut point on split road segments.}
}
}
\description{
Group cases into neighborhoods based on walking distance.
}
\examples{
\donttest{
neighborhoodWalking()
neighborhoodWalking(pump.select = -6)
}
}
