% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walkingDistance.R
\name{walkingDistance}
\alias{walkingDistance}
\title{Compute the shortest walking distance between cases and/or pumps.}
\usage{
walkingDistance(origin, destination = NULL, type = "case-pump",
  observed = TRUE, weighted = TRUE, vestry = FALSE, unit = NULL)
}
\arguments{
\item{origin}{Numeric or Integer. Numeric ID of case or pump.}

\item{destination}{Numeric or Integer. Numeric ID(s) of case(s) or pump(s). Exclusion is possible via negative selection (e.g., -7). Default is NULL: this returns closest pump or "anchor" case.}

\item{type}{Character "case-pump", "cases" or "pumps".}

\item{observed}{Logical. Use observed or "simulated" expected data.}

\item{weighted}{Logical. TRUE computes shortest path in terms of road length. FALSE computes shortest path in terms of nodes.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{unit}{Character. Unit of measurement: "meter" or "yard". Default is NULL, which returns the map's native scale. Meaningful only when "weighted" is TRUE. See \code{vignette("roads")} for information on unit distances.}
}
\value{
An R list.
}
\description{
Compute the shortest walking distance between cases and/or pumps.
}
\note{
The function uses a case's "address" or "anchor" case to compute distance.

Adam and Eve Court, and Falconberg Court and Falconberg Mews, are disconnected from the larger road network and form two isolated subgraphs. This has two consequences: first, only cases on Adam and Eve Court can reach pump 2 and those cases cannot reach any other pump; second, cases on Falconberg Court and Mews cannot reach any pump. Unreachable pumps will return distances of "Inf".
}
\examples{
# path from case 1 to nearest pump.
# walkingDistance(1)

# path from case 1 to nearest pump in meters (appox).
# walkingDistance(1, unit = "meter")

# path from case 1 to pump 6.
# walkingDistance(1, 6)

# exclude pump 7 from consideration.
# walkingDistance(1, -7)

# path from case 1 to case 6.
# walkingDistance(1, 6, type = "cases")

# path from pump 1 to pump 6.
# walkingDistance(1, 6, type = "pumps")

# Plot result
# plot(walkingDistance(1, unit = "meter"))
}
\seealso{
\code{\link{fatalities}}, \code{vignette("pump.neighborhoods")}
}
