% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/childesr.R
\name{get_tokens}
\alias{get_tokens}
\title{Get tokens}
\usage{
get_tokens(
  collection = NULL,
  language = NULL,
  corpus = NULL,
  target_child = NULL,
  role = NULL,
  role_exclude = NULL,
  age = NULL,
  sex = NULL,
  token,
  stem = NULL,
  part_of_speech = NULL,
  replace = TRUE,
  connection = NULL,
  db_version = "current",
  db_args = NULL
)
}
\arguments{
\item{collection}{A character vector of one or more names of collections}

\item{language}{A character vector of one or more languages}

\item{corpus}{A character vector of one or more names of corpora}

\item{target_child}{A character vector of one or more names of children}

\item{role}{A character vector of one or more roles to include}

\item{role_exclude}{A character vector of one or more roles to exclude}

\item{age}{A numeric vector of an single age value or a min age value and max
age value (inclusive) in months. For a single age value, participants are
returned for which that age is within their age range; for two ages,
participants are returned for whose age overlaps with the interval between
those two ages.}

\item{sex}{A character vector of values "male" and/or "female"}

\item{token}{A character vector of one or more token patterns (`\%` matches
any number of wildcard characters, `_` matches exactly one wildcard
character)}

\item{stem}{A character vector of one or more stems}

\item{part_of_speech}{A character vector of one or more parts of speech}

\item{replace}{A boolean indicating whether to replace "gloss" with
"replacement" (i.e. phonologically assimilated form), when available
(defaults to \code{TRUE})}

\item{connection}{A connection to the CHILDES database}

\item{db_version}{String of the name of database version to use}

\item{db_args}{List with host, user, and password defined}
}
\value{
A `tbl` of Token data, filtered down by supplied arguments. If
  `connection` is supplied, the result remains a remote query, otherwise it
  is retrieved into a local tibble.
}
\description{
Get tokens
}
\examples{
\donttest{
get_tokens(token = "dog")
}
}
