% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCC_parallel.R
\name{hcc_parallel}
\alias{hcc_parallel}
\title{hcc_parallel}
\usage{
hcc_parallel(
  Data,
  W,
  K,
  maxLevel,
  ncores = 2,
  DIR_output = tempfile(),
  hybrid = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{Data}{A Filebacked Big Matrix n x N. Data signals are stored in the matrix columns.}

\item{W}{A frequency matrix m x n with frequency vectros in rows.}

\item{K}{Number of clusters at each call of the clustering algorithm.}

\item{maxLevel}{Maximum number of hierarchical levels.}

\item{ncores}{Number of cores. By default 4.}

\item{DIR_output}{An output directory.}

\item{hybrid}{logical parameter. If TRUE \code{K} decreases progressively over
hierarchical levels as \eqn{\lceil \frac{K}{level} \rceil}. Default is FALSE.}

\item{verbose}{logical that indicates whether dysplay the processing steps.}

\item{...}{Additional arguments passed on to \code{\link{COMPR}}.}
}
\value{
The cluster assignment as a list of clusters with corresponding data vector indeces.
}
\description{
Compressed Hierarchical Clustering.
}
\details{
This function provides a divisive hierarchical implementation of \code{\link{COMPR}}.
Parallel computations are performed using 'FORK' clusters (Linux-like platform) or 'PSOCK' clusters (Windows platform) using the \code{parallel} package.
This function generates in the \code{DIR_output} directory the following files:
\itemize{
\item 'Cluster_assign_out.bk' is a Filebacked Big Matrix N x \code{maxLevel}+1, which stores the cluster assignment at each hierarchical level.
\item 'Centroids_out.bk' is a Filebacked Big Matrix with the resulting cluster centroids in columns.
}
}
\examples{
\donttest{
data("UPS2")
N = ncol(UPS2)
n= nrow(UPS2)
X_FBM = bigstatsr::FBM(init = UPS2, ncol=N, nrow = n)$save()
K_W1 = Nystrom_kernel(Data = X_FBM, c = 14, l = 7, s = 5, 
                      max_neighbors = 3, ncores = 1, kernel = 'Gaussian')$K_W1
W = GenerateFrequencies(Data = K_W1, m = 20, N0 = ncol(X_FBM))$W
C = hcc_parallel(Data = K_W1, W = W, K = 2, maxLevel = 4, 
                 DIR_output = tempfile(), ncores = 2)
}
}
\references{
\insertRef{DBLP:journals/corr/KerivenTTG16}{chickn}
}
\seealso{
\code{\link{COMPR}}
}
