% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdt01.R
\docType{data}
\name{pdt01_main}
\alias{pdt01_main}
\alias{pdt01_pre}
\alias{pdt01_post}
\alias{pdt01}
\title{\code{pdt01} Major Protocol Deviations Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
pdt01_main(
  adam_db,
  arm_var = "ARM",
  lbl_overall = NULL,
  dvcode_var = "DVDECOD",
  dvterm_var = "DVTERM",
  ...
)

pdt01_pre(adam_db, ...)

pdt01_post(
  tlg,
  prune_0 = TRUE,
  dvcode_var = "DVDECOD",
  dvterm_var = "DVTERM",
  ...
)

pdt01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{dvcode_var}{(\code{string}) the variable defining the protocol deviation coded term. By default \code{DVDECOD}.}

\item{dvterm_var}{(\code{string}) the variable defining the protocol deviation term. By default \code{DVTERM}.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
A major protocol deviations
table with the number of subjects and the total number of treatments by medication class sorted alphabetically and
medication name sorted by frequencies.
}
\details{
\itemize{
\item Data should be filtered for major protocol deviations. \code{(DVCAT == "MAJOR")}.
\item Numbers represent absolute numbers of subjects and fraction of \code{N}, or absolute numbers when specified.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm.
\item Does not include a total column by default.
\item Sort by medication class alphabetically and within medication class by decreasing total number of patients with
the specific medication.
}
}
\section{Functions}{
\itemize{
\item \code{pdt01_main()}: Main TLG function

\item \code{pdt01_pre()}: Preprocessing

\item \code{pdt01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{addv} table with the columns specified in \code{dvcode_var} and \code{dvterm_var} as well
as \code{"DVSEQ"}.
}
}
\examples{
run(pdt01, syn_data)
}
\keyword{datasets}
