% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbt01.R
\docType{data}
\name{cfbt01_main}
\alias{cfbt01_main}
\alias{cfbt01_pre}
\alias{cfbt01_post}
\alias{cfbt01}
\title{\code{CFBT01} Change from Baseline By Visit Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
cfbt01_main(
  adam_db,
  dataset,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  row_split_var = NULL,
  summaryvars = c("AVAL", "CHG"),
  visitvar = "AVISIT",
  precision = list(default = 2L),
  page_var = "PARAMCD",
  .stats = c("n", "mean_sd", "median", "range"),
  skip = list(CHG = "BASELINE"),
  ...
)

cfbt01_pre(adam_db, dataset, ...)

cfbt01_post(tlg, prune_0 = TRUE, ...)

cfbt01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{summaryvars}{(\code{character}) variables to be analyzed. The label attribute of the corresponding column in
table of \code{adam_db} is used as label.}

\item{visitvar}{(\code{string}) typically one of \code{"AVISIT"} or user-defined visit incorporating \code{"ATPT"}.}

\item{precision}{(named \code{list} of \code{integer}) where names are values found in the \code{PARAMCD} column and the values
indicate the number of digits in statistics. If \code{default} is set, and parameter precision not specified,
the value for \code{default} will be used. If \code{default} is not set, the default precision is 2.}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{.stats}{(\code{character}) statistics names, see \code{tern::analyze_vars()}.}

\item{skip}{Named (\code{list}) of visit values that need to be inhibited.}

\item{...}{additional arguments like \code{.indent_mods}, \code{.labels}.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{CFBT01} table provides an
overview of the actual values and its change from baseline of each respective arm
over the course of the trial.
}
\details{
\itemize{
\item The \verb{Analysis Value} column, displays the number of patients, the mean, standard deviation, median and range of
the analysis value for each visit.
\item The \verb{Change from Baseline} column, displays the number of patient and the mean, standard deviation,
median and range of changes relative to the baseline.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm, typically \code{ACTARM}.
\item Does not include a total column by default.
\item Sorted  based on factor level; first by \code{PARAM} labels in alphabetic order then by chronological time point given
by \code{AVISIT}. Re-level to customize order
}
}
\section{Functions}{
\itemize{
\item \code{cfbt01_main()}: Main TLG function

\item \code{cfbt01_pre()}: Preprocessing

\item \code{cfbt01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain table named as \code{dataset} with the columns specified in \code{summaryvars}.
}
}
\examples{
library(dunlin)

proc_data <- log_filter(
  syn_data,
  PARAMCD \%in\% c("DIABP", "SYSBP"), "advs"
)
run(cfbt01, proc_data, dataset = "advs")
}
\keyword{datasets}
