#' Arabis alpina floral scent data
#'
#' A dataset with proportional floral scent data from three populations of
#' the plant Arabis alpina.
#'
#' @format A data frame with 87 rows and 15 columns. Each row is a sample,
#' each column is a floral scent compound.
#'
#' @source Petren H, Torang P, Agren J, Friberg M. 2021.
#' Evolution of floral scent in relation to self-incompatibility and capacity
#' for autonomous self-pollination in the perennial herb *Arabis alpina*.
#' Annals of Botany 127: 737-747.
"alpinaSampData"

#' Arabis alpina floral scent compounds
#'
#' A dataset listing the compounds in \code{\link{alpinaSampData}}.
#'
#' @format A data frame with 15 rows and 3 columns. Each row is a compound.
#' First column is a common name of the compound, second column is the
#' SMILES (Simplified Molecular-Input Line-Entry System) specification,
#' third column is the InChIKey (International Chemical Identifier).
#'
#' @source Petren H, Torang P, Agren J, Friberg M. 2021.
#' Evolution of floral scent in relation to self-incompatibility and capacity
#' for autonomous self-pollination in the perennial herb *Arabis alpina*.
#' Annals of Botany 127: 737-747.
"alpinaCompData"

#' Arabis alpina populations
#'
#' A dataset listing what population each sample
#' in \code{\link{alpinaSampData}} comes from.
#'
#' @format A data frame with 87 rows and 1 column. Each row represents
#' the population each sample in \code{\link{alpinaSampData}} comes from
#' (It8, S1 or G1).
#'
#' @source Petren H, Torang P, Agren J, Friberg M. 2021.
#' Evolution of floral scent in relation to self-incompatibility and capacity
#' for autonomous self-pollination in the perennial herb *Arabis alpina*.
#' Annals of Botany 127: 737-747.
"alpinaPopData"

#' Arabis alpina floral scent compound dissimilarity matrix
#'
#' A matrix with compound dissimilarities calculated using
#' \code{\link{compDis}} with \code{type = "PubChemFingerprint"},
#' for the compounds in \code{\link{alpinaCompData}}.
#'
#' @format A 15x15 compound dissimilarity matrix.
"alpinaCompDis"

#' Arabis alpina floral scent sample dissimilarity matrix
#'
#' A matrix with sample dissimilarities calculated from
#' \code{\link{alpinaSampData}} and \code{\link{alpinaCompDis}}
#' using \code{\link{sampDis}} with \code{type = "GenUniFrac"} and
#' \code{alpha = 0.5}.
#'
#' @format A 87x87 sample dissimilarity matrix.
"alpinaSampDis"

#' Arabis alpina floral scent NPClassifier table
#'
#' A table with the NPClassifier pathways, superclasses and classes,
#' along with the compound names, smiles and inchikey. Generated by
#' the \code{\link{NPCTable}} function used on the
#' \code{\link{alpinaCompData}} dataset.
#'
#' @format A dataframe with 15 compounds and their NPClassifier classifications.
"alpinaNPCTable"

#' Arabis alpina floral scent molecular network
#'
#' A molecular network. Generated by the \code{\link{molNet}} function
#' used on the \code{\link{alpinaCompDis}} dataset, with
#' \code{cutOff = 0.75}.
#'
#' @format A \code{tbl_graph} object with 15 nodes and 56 edges.
"alpinaMolNet"

#' Minimal sample dataset
#'
#' A small made up dataset with phytochemical data.
#'
#' @format A data frame with 4 rows and 3 columns. Each row is a sample,
#' each column is a phytochemical compound.
"minimalSampData"

#' Minimal compound dataset
#'
#' A small dataset with three phytochemical compounds.
#'
#' @format A data frame with 3 rows and 3 columns. Each row is a phytochemical
#' compound. First column is a common name of the compound, second column is
#' the SMILES (Simplified Molecular-Input Line-Entry System) specification,
#' third column is the InChIKey (International Chemical Identifier).
"minimalCompData"

#' Minimal compound dissimilarity matrix
#'
#' A matrix with compound dissimilarities calculated using
#' \code{\link{compDis}} with \code{type = "PubChemFingerprint"},
#' for the compounds in \code{\link{minimalCompData}}.
#'
#' @format A 3x3 compound dissimilarity matrix.
"minimalCompDis"

#' Minimal sample dissimilarity matrix
#'
#' A matrix with sample dissimilarities calculated from
#' \code{\link{minimalSampData}} and \code{\link{minimalCompDis}}
#' using \code{\link{sampDis}} with \code{type = "GenUniFrac"} and
#' \code{alpha = 0.5}.
#'
#' @format A 4x4 sample dissimilarity matrix.
"minimalSampDis"

#' Minimal NPClassifier table
#'
#' A table with the NPClassifier pathways, superclasses and classes,
#' along with the compound names, smiles and inchikey. Generated by
#' the \code{\link{NPCTable}} function used on the
#' \code{\link{minimalCompData}} dataset.
#'
#' @format A dataframe with 3 compounds and their NPClassifier classifications.
"minimalNPCTable"

#' Minimal molecular network
#'
#' A molecular network. Generated by the \code{\link{molNet}} function
#' used on the \code{\link{minimalCompDis}} dataset, with
#' \code{cutOff = "median"}.
#'
#' @format A \code{tbl_graph} object with 3 nodes and 4 edges.
"minimalMolNet"
