% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/det_order.R
\name{f_gen}
\alias{f_gen}
\title{Formula of an n-order model.}
\usage{
f_gen(n)
}
\arguments{
\item{n}{reaction order}
}
\value{
A formula object containing the equation of the selected \emph{n}^th^
order kinetic model.
}
\description{
Given the reaction order \eqn{n} , the function returns the equation
corresponding to that particular n^th^-order kinetic model.
For \eqn{n\neq 1}:
\deqn{y(t)=((n-1)\,k\,t+y_0^{1-n}))^{\frac{1}{n-1}}}
for \eqn{n=1}:
\deqn{y(t)=y_0\,e^{-k\,t}}
}
\examples{
nc <- 2
f_gen(nc)

f_gen(1)
}
