\name{loq}
\alias{loq}
\alias{loq.lm}
\alias{loq.rlm}
\alias{loq.default}
\title{Estimate a limit of quantification (LOQ)}
\usage{
  loq(object, \dots, alpha = 0.05, k = 3, n = 1, w.loq = "auto",
    var.loq = "auto", tol = "default")
}
\arguments{
  \item{object}{
    A univariate model object of class \code{\link{lm}} or 
    \code{\link[MASS:rlm]{rlm}} 
    with model formula \code{y ~ x} or \code{y ~ x - 1}, 
    optionally from a weighted regression. If weights are specified
    in the model, either \code{w.loq} or \code{var.loq} have to 
    be specified.
  }
  \item{alpha}{
    The error tolerance for the prediction of x values in the calculation.
  }
  \item{\dots}{
    Placeholder for further arguments that might be needed by 
    future implementations.
  }
  \item{k}{ 
    The inverse of the maximum relative error tolerated at the
    desired LOQ.
  }
  \item{n}{
    The number of replicate measurements for which the LOQ should be
    specified.
  }
  \item{w.loq}{
    The weight that should be attributed to the LOQ. Defaults
    to one for unweighted regression, and to the mean of the weights
    for weighted regression. See \code{\link{massart97ex3}} for 
    an example how to take advantage of knowledge about the 
    variance function.
  }
  \item{var.loq}{
    The approximate variance at the LOQ. The default value is 
    calculated from the model.
  }
  \item{tol}{
    The default tolerance for the LOQ on the x scale is the value of the
    smallest non-zero standard divided by 1000. Can be set to a 
    numeric value to override this.
  }
}
\value{
  The estimated limit of quantification for a model used for calibration.
}
\description{
  The limit of quantification is the x value, where the relative error
  of the quantification given the calibration model reaches a prespecified
  value 1/k. Thus, it is the solution of the equation
    \deqn{L = k c(L)}{L = k * c(L)}
  where c(L) is half of the length of the confidence interval at the limit L
  (DIN 32645, equivalent to ISO 11843). c(L) is internally estimated by
  \code{\link{inverse.predict}}, and L is obtained by iteration. 
}
\note{
  - IUPAC recommends to base the LOQ on the standard deviation of the signal
    where x = 0. 
  - The calculation of a LOQ based on weighted regression is non-standard
    and therefore not tested. Feedback is welcome.
}
\examples{
m <- lm(y ~ x, data = massart97ex1)
loq(m)

# We can get better by using replicate measurements
loq(m, n = 3)
}
\seealso{
  Examples for \code{\link{din32645}}  
}
\keyword{manip}
