% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assert}
\alias{assert}
\title{Combine multiple checks into one assertion}
\usage{
assert(..., combine = "or", .var.name = NULL)
}
\arguments{
\item{...}{[any]\cr
List of calls to check functions.}

\item{combine}{[\code{character(1)}]\cr
\dQuote{or} or \dQuote{and} to combine the check functions with an OR
or AND, respectively.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in error messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Throws an error if all checks fail and invisibly returns
 \code{TRUE} otherwise.
}
\description{
You can call this function with an arbitrary number of of \code{check*}
functions, i.e. functions provided by this package or your own functions which
return \code{TRUE} on success and the error message as \code{character(1)} otherwise.
The resulting assertion is successful, if \code{combine} is
\dQuote{or} (default) and at least one check evaluates to \code{TRUE} or
\code{combine} is \dQuote{and} and all checks evaluate to \code{TRUE}.
Otherwise, \code{assert} throws an informative error message.
}
\examples{
x = 1:10
assert(checkNull(x), checkInteger(x, any.missing = FALSE))
\dontrun{
x = 1
assert(checkChoice(x, c("a", "b")), checkDataFrame(x))
}
}

