% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{options_params}
\alias{options_params}
\title{Checked Options}
\arguments{
\item{results_error_on}{character vector indicating whether R error should be thrown when issues
are discovered when generating results. "never" means that no errors
are thrown. If "issues" then errors are emitted only on issues, whereas
"potential issues" stands for error on both issues and potential issues. (Defaults to \code{"never"}, overwritable using option 'checked.results_error_on' or environment variable 'R_CHECKED_RESULTS_ERROR_ON')}

\item{check_args}{\code{character} vector of args passed to the R CMD check. (Defaults to \code{c("--timings", "--ignore-vignettes", "--no-manual")}, overwritable using option 'checked.check_args' or environment variable 'R_CHECKED_CHECK_ARGS')}

\item{results_keep}{character vector indicating which packages should be included in the results.
"all" means that all packages are kept. If "issues" then only packages
with issues identified, whereas "potential_issues" stands for keeping
packages with both "issues" and "potential_issues". (Defaults to \code{"all"}, overwritable using option 'checked.results_keep' or environment variable 'R_CHECKED_RESULTS_KEEP')}

\item{check_envvars}{named \code{character} vector of environment variables to use during R CMD check. (Defaults to \verb{c(}\emph{R_CHECK_FORCE_SUGGESTS}\verb{= FALSE,}\emph{R_CHECK_RD_XREFS}\verb{= FALSE, ;    }\emph{R_CHECK_SYSTEM_CLOCK}\verb{= FALSE,}\emph{R_CHECK_SUGGESTS_ONLY}\verb{ = TRUE)}, overwritable using option 'checked.check_envvars' or environment variable 'R_CHECKED_CHECK_ENVVARS')}

\item{tty_tick_interval}{tty refresh interval when reporting results in milliseconds (Defaults to \code{0.1}, overwritable using option 'checked.tty_tick_interval' or environment variable 'R_CHECKED_TTY_TICK_INTERVAL')}

\item{check_build_args}{\code{character} vector of args passed to the R CMD build. (Defaults to \code{c("--no-build-vignettes", "--no-manual")}, overwritable using option 'checked.check_build_args' or environment variable 'R_CHECKED_CHECK_BUILD_ARGS')}

\item{restore}{\code{logical} indicating whether output directory should be unlinked before
running checks. If \code{FALSE}, an attempt will me made to restore previous
progress from the same \code{output} (Defaults to \code{NA}, overwritable using option 'checked.restore' or environment variable 'R_CHECKED_RESTORE')}
}
\description{
Checked Options
}
\seealso{
Other documentation: 
\code{\link{options}()}
}
\concept{documentation}
