#' ChatGPT: Explain Code
#'
#' @param code The code to be explained by ChatGPT.
#'
#' @examples
#' \dontrun{
#' cat(explain_code("for (i in 1:10) {\n  print(i ** 2)\n}"))
#' }
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
explain_code <- function(code) {
  prompt <- paste0('Explain the following R code: "', code, '"')
  parse_response(gpt_get_completions(prompt))
}
