% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_orders.R
\name{get_orders}
\alias{get_orders}
\title{Get Orders}
\usage{
get_orders(
  tokens,
  from_entered_datetime = strftime(Sys.time() - lubridate::days(60), format =
    "\%Y-\%m-\%dT\%H:\%M:\%S.000Z"),
  to_entered_datetime = strftime(Sys.time(), format = "\%Y-\%m-\%dT\%H:\%M:\%S.000Z"),
  max_results = NULL,
  status = NULL
)
}
\arguments{
\item{tokens}{token object from `get_authentication_tokens` function (list).}

\item{from_entered_datetime}{encrypted ID of the account - default is current datetime less 60 days (string).}

\item{to_entered_datetime}{specific fields to be returned - default is current datetime (string).}

\item{max_results}{maximum number of results to be returned - default is NULL, which is 3000 (numeric).}

\item{status}{only orders of this status should be returned. Default is NULL, which is all statuses. Valid values are "AWAITING_PARENT_ORDER", "AWAITING_CONDITION", "AWAITING_STOP_CONDITION", "AWAITING_MANUAL_REVIEW", "ACCEPTED", "AWAITING_UR_OUT", "PENDING_ACTIVATION", "QUEUED", "WORKING", "REJECTED", "PENDING_CANCEL", "CANCELED", "PENDING_REPLACE", "REPLACED", "FILLED", "EXPIRED", "NEW", "AWAITING_RELEASE_TIME", "PENDING_ACKNOWLEDGEMENT", "PENDING_RECALL", and "UNKNOWN" (string).}
}
\value{
Returns a data frame containing order information for all
        accounts affiliated with authorized user.
}
\description{
Given the tokens object from the `get_authentication_tokens`
function, return a data frame containing the orders for all
accounts related to the authenticated user. By default, it
will return all orders (default max is 3000) from the last 60 days.
This can be adjusted through additional function parameters.
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, July 2024
}
\keyword{orders}
