% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address-provider-en_US.R
\name{AddressProvider_en_US}
\alias{AddressProvider_en_US}
\title{AddressProvider for United States of America}
\value{
Returns an AddressProvider object.
}
\description{
Object to create addresses for a locale.
Makes use of \link{PersonProvider} for creating street names.
}
\details{
When there is no PersonProvider for this locale, we default back to en_US.
}
\examples{
(z <- AddressProvider_en_US$new())
z$locale
z$postcode()
z$street_name()
z$address()
z$city()
z$mil_address()
z$civ_address()
}
\seealso{
Other en: 
\code{\link{AddressProvider_en_GB}},
\code{\link{AddressProvider_en_NZ}},
\code{\link{ColorProvider_en_US}},
\code{\link{CompanyProvider_en_US}},
\code{\link{ElementProvider_en_US}},
\code{\link{FileProvider_en_US}},
\code{\link{InternetProvider_en_AU}},
\code{\link{InternetProvider_en_US}},
\code{\link{JobProvider_en_US}},
\code{\link{LoremProvider_en_US}},
\code{\link{PersonProvider_en_GB}},
\code{\link{PersonProvider_en_NZ}},
\code{\link{PersonProvider_en_US}},
\code{\link{PhoneNumberProvider_en_AU}},
\code{\link{PhoneNumberProvider_en_CA}},
\code{\link{PhoneNumberProvider_en_GB}},
\code{\link{PhoneNumberProvider_en_NZ}},
\code{\link{PhoneNumberProvider_en_US}},
\code{\link{PhoneNumberProvider_es_MX}},
\code{\link{SSNProvider_en_US}},
\code{\link{TaxonomyProvider_en_US}},
\code{\link{UserAgentProvider_en_US}},
\code{\link{english-language}}

Other US: 
\code{\link{ColorProvider_en_US}},
\code{\link{CompanyProvider_en_US}},
\code{\link{ElementProvider_en_US}},
\code{\link{FileProvider_en_US}},
\code{\link{InternetProvider_en_US}},
\code{\link{JobProvider_en_US}},
\code{\link{LoremProvider_en_US}},
\code{\link{PersonProvider_en_US}},
\code{\link{PhoneNumberProvider_en_US}},
\code{\link{SSNProvider_en_US}},
\code{\link{TaxonomyProvider_en_US}},
\code{\link{UserAgentProvider_en_US}}
}
\concept{US}
\concept{en}
\section{Super classes}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{\link[charlatan:AddressProvider]{charlatan::AddressProvider}} -> \code{AddressProvider_en_US}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AddressProvider_en_US-address}{\code{AddressProvider_en_US$address()}}
\item \href{#method-AddressProvider_en_US-civ_address}{\code{AddressProvider_en_US$civ_address()}}
\item \href{#method-AddressProvider_en_US-mil_address}{\code{AddressProvider_en_US$mil_address()}}
\item \href{#method-AddressProvider_en_US-city}{\code{AddressProvider_en_US$city()}}
\item \href{#method-AddressProvider_en_US-street_name}{\code{AddressProvider_en_US$street_name()}}
\item \href{#method-AddressProvider_en_US-street_address}{\code{AddressProvider_en_US$street_address()}}
\item \href{#method-AddressProvider_en_US-postcode}{\code{AddressProvider_en_US$postcode()}}
\item \href{#method-AddressProvider_en_US-building_number}{\code{AddressProvider_en_US$building_number()}}
\item \href{#method-AddressProvider_en_US-state}{\code{AddressProvider_en_US$state()}}
\item \href{#method-AddressProvider_en_US-clone}{\code{AddressProvider_en_US$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="allowed_locales"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-allowed_locales'><code>charlatan::BaseProvider$allowed_locales()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="print"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-print'><code>charlatan::BaseProvider$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="AddressProvider" data-id="init_person_provider"><a href='../../charlatan/html/AddressProvider.html#method-AddressProvider-init_person_provider'><code>charlatan::AddressProvider$init_person_provider()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="AddressProvider" data-id="initialize"><a href='../../charlatan/html/AddressProvider.html#method-AddressProvider-initialize'><code>charlatan::AddressProvider$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-address}{}}}
\subsection{Method \code{address()}}{
address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-civ_address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-civ_address}{}}}
\subsection{Method \code{civ_address()}}{
civilian address, the type of address you would expect. Not to be confused with Military address which is also available for this locale.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$civ_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-mil_address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-mil_address}{}}}
\subsection{Method \code{mil_address()}}{
Military address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$mil_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-city"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-city}{}}}
\subsection{Method \code{city()}}{
city
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$city()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-street_name"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-street_name}{}}}
\subsection{Method \code{street_name()}}{
street name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$street_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-street_address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-street_address}{}}}
\subsection{Method \code{street_address()}}{
street address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$street_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-postcode"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-postcode}{}}}
\subsection{Method \code{postcode()}}{
postal code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$postcode()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-building_number"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-building_number}{}}}
\subsection{Method \code{building_number()}}{
building number
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$building_number()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-state"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-state}{}}}
\subsection{Method \code{state()}}{
state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$state()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_US-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_US-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_US$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
