# modified from the python library faker:
# https://github.com/joke2k/faker/blob/master/faker/providers/address/en_US/__init__.py

city_prefixes_en_us <- c('North', 'East', 'West', 'South', 'New', 'Lake', 'Port')

city_suffixes_en_us <- c(
  'town',
  'ton',
  'land',
  'ville',
  'berg',
  'burgh',
  'borough',
  'bury',
  'view',
  'port',
  'mouth',
  'stad',
  'furt',
  'chester',
  'fort',
  'haven',
  'side',
  'shire'
)

building_number_formats_en_us <- c('#####', '####', '###')

street_suffixes_en_us <- c(
  'Alley',
  'Avenue',
  'Branch',
  'Bridge',
  'Brook',
  'Brooks',
  'Burg',
  'Burgs',
  'Bypass',
  'Camp',
  'Canyon',
  'Cape',
  'Causeway',
  'Center',
  'Centers',
  'Circle',
  'Circles',
  'Cliff',
  'Cliffs',
  'Club',
  'Common',
  'Corner',
  'Corners',
  'Course',
  'Court',
  'Courts',
  'Cove',
  'Coves',
  'Creek',
  'Crescent',
  'Crest',
  'Crossing',
  'Crossroad',
  'Curve',
  'Dale',
  'Dam',
  'Divide',
  'Drive',
  'Drives',
  'Estate',
  'Estates',
  'Expressway',
  'Extension',
  'Extensions',
  'Fall',
  'Falls',
  'Ferry',
  'Field',
  'Fields',
  'Flat',
  'Flats',
  'Ford',
  'Fords',
  'Forest',
  'Forge',
  'Forges',
  'Fork',
  'Forks',
  'Fort',
  'Freeway',
  'Garden',
  'Gardens',
  'Gateway',
  'Glen',
  'Glens',
  'Green',
  'Greens',
  'Grove',
  'Groves',
  'Harbor',
  'Harbors',
  'Haven',
  'Heights',
  'Highway',
  'Hill',
  'Hills',
  'Hollow',
  'Inlet',
  'Island',
  'Islands',
  'Isle',
  'Junction',
  'Junctions',
  'Key',
  'Keys',
  'Knoll',
  'Knolls',
  'Lake',
  'Lakes',
  'Land',
  'Landing',
  'Lane',
  'Light',
  'Lights',
  'Loaf',
  'Lock',
  'Locks',
  'Lodge',
  'Loop',
  'Mall',
  'Manor',
  'Manors',
  'Meadow',
  'Meadows',
  'Mews',
  'Mill',
  'Mills',
  'Mission',
  'Motorway',
  'Mount',
  'Mountain',
  'Mountains',
  'Neck',
  'Orchard',
  'Oval',
  'Overpass',
  'Park',
  'Parks',
  'Parkway',
  'Parkways',
  'Pass',
  'Passage',
  'Path',
  'Pike',
  'Pine',
  'Pines',
  'Place',
  'Plain',
  'Plains',
  'Plaza',
  'Point',
  'Points',
  'Port',
  'Ports',
  'Prairie',
  'Radial',
  'Ramp',
  'Ranch',
  'Rapid',
  'Rapids',
  'Rest',
  'Ridge',
  'Ridges',
  'River',
  'Road',
  'Roads',
  'Route',
  'Row',
  'Rue',
  'Run',
  'Shoal',
  'Shoals',
  'Shore',
  'Shores',
  'Skyway',
  'Spring',
  'Springs',
  'Spur',
  'Spurs',
  'Square',
  'Squares',
  'Station',
  'Stravenue',
  'Stream',
  'Street',
  'Streets',
  'Summit',
  'Terrace',
  'Throughway',
  'Trace',
  'Track',
  'Trafficway',
  'Trail',
  'Tunnel',
  'Turnpike',
  'Underpass',
  'Union',
  'Unions',
  'Valley',
  'Valleys',
  'Via',
  'Viaduct',
  'View',
  'Views',
  'Village',
  'Villages',
  'Ville',
  'Vista',
  'Walk',
  'Walks',
  'Wall',
  'Way',
  'Ways',
  'Well',
  'Wells'
)

postcode_formats_en_us <- c('#####', '#####-####')

states_en_us <- c(
  'Alabama', 'Alaska', 'Arizona', 'Arkansas', 'California', 'Colorado',
  'Connecticut', 'Delaware', 'Florida', 'Georgia', 'Hawaii', 'Idaho',
  'Illinois', 'Indiana', 'Iowa', 'Kansas', 'Kentucky', 'Louisiana',
  'Maine', 'Maryland', 'Massachusetts', 'Michigan', 'Minnesota',
  'Mississippi', 'Missouri', 'Montana', 'Nebraska', 'Nevada',
  'New Hampshire', 'New Jersey', 'New Mexico', 'New York',
  'North Carolina', 'North Dakota', 'Ohio', 'Oklahoma', 'Oregon',
  'Pennsylvania', 'Rhode Island', 'South Carolina', 'South Dakota',
  'Tennessee', 'Texas', 'Utah', 'Vermont', 'Virginia', 'Washington',
  'West Virginia', 'Wisconsin', 'Wyoming'
)
states_abbr_en_us <- c(
  'AL', 'AK', 'AS', 'AZ', 'AR', 'CA', 'CO', 'CT', 'DE', 'DC', 'FM', 'FL',
  'GA', 'GU', 'HI', 'ID', 'IL', 'IN', 'IA', 'KS', 'KY', 'LA', 'ME', 'MH',
  'MD', 'MA', 'MI', 'MN', 'MS', 'MO', 'MT', 'NE', 'NV', 'NH', 'NJ', 'NM',
  'NY', 'NC', 'ND', 'MP', 'OH', 'OK', 'OR', 'PW', 'PA', 'PR', 'RI', 'SC',
  'SD', 'TN', 'TX', 'UT', 'VT', 'VI', 'VA', 'WA', 'WV', 'WI', 'WY'
)

military_state_abbr_en_us <- c('AE', 'AA', 'AP')

military_ship_prefix_en_us <- c('USS', 'USNS', 'USNV', 'USCGC')

military_apo_format_en_us <- c("PSC ####, Box ####")

military_dpo_format_en_us <- c("Unit #### Box ####")

city_formats_en_us <- c(
  '{{city_prefix}} {{first_name}}{{city_suffix}}',
  '{{city_prefix}} {{first_name}}',
  '{{first_name}}{{city_suffix}}',
  '{{last_name}}{{city_suffix}}'
)

street_name_formats_en_us <- c(
  '{{first_name}} {{street_suffix}}',
  '{{last_name}} {{street_suffix}}'
)

street_address_formats_en_us <- c(
  '{{building_number}} {{street_name}}',
  '{{building_number}} {{street_name}} {{secondary_address}}'
)

address_formats_en_us <- "{{street_address}}\n{{city}}, {{state_abbr}} {{postcode}}"

# address_formats = OrderedDict((
#   ("{{street_address}}\n{{city}}, {{state_abbr}} {{postcode}}", 25),
#   #  military address formatting.
#   ("{{military_apo}}\nAPO {{military_state}} {{postcode}}", 1),
#   ("{{military_ship}} {{last_name}}\nFPO {{military_state}} {{postcode}}", 1),
#   ("{{military_dpo}}\nDPO {{military_state}} {{postcode}}", 1),
# ))

secondary_address_formats_en_us <- c('Apt. ###', 'Suite ###')
