\name{tree}

\alias{tree}

\title{Specify a Tree-Ordering in a CGAM Formula}

\description{A symbolic routine to define that the systematic component \eqn{\eta} has a tree-ordering in a predictor in a formula argument to cgam.}

\usage{tree(x)}

\arguments{
  \item{x}{A numeric vector which has the same length as the response vector. Note that the placebo level of x must be 0.}
}

\value{The vector x with two attributes, i.e., name: the name of x; shape: "tree".}

\details{
  "tree" returns the vector "x" and imposes on it two attributes: name and shape. 

  The name attribute is used in the subroutines: predict.cgam and plotpersp; the shape attribute is "tree", and according to the value of the vector itself and its shape attribute, the cone edges of the cone generated by the constraint matrix, which constrains that \eqn{\eta} has a tree-ordering in "x"  will be made. The cone edges are a set of basis employed in the hinge algorithm. 

  Note that "tree" does not make the corresponding cone edges itself. It sets things up to a sub-routine called tree.fun in cgam which will make the cone edges. A tree-ordering is a partial ordering: For a categorical variable \eqn{x}, if there are treatment levels \eqn{x_1,\ldots,x_k}, where \eqn{x_1} is a placebo, we compare \eqn{x_i, i = 2,\ldots,k} with \eqn{x_1}, and not have any other comparable pairs.

  See references cited in this section for more details.
}

\author{
  Mary C. Meyer and Xiyue Liao
}

\references{
   Meyer, M. C. (2013b) A simple new algorithm for quadratic programming with applications in statistics. \emph{Communications in Statistics \bold{42(5)}}, 1126--1139. 
}

\examples{
  # generate y
  set.seed(123)
  n <- 12 
  x <- rep(0:2, each = 4)
  y <- x + rnorm(n, .1)

  # regress y on x under the tree-ordering restriction
  ans <- cgam(y ~ tree(x)) 

  # make a plot
  par(mar = c(4, 4, 1, 1))
  plot(y, cex = .7, ylab = "y")
  lines(ans$muhat, col = 2)
  legend("topleft", bty = "n", "tree-ordering fit", col = 2, lty = 1)
}

\seealso{
  \code{\link{umbrella}}
}

\keyword{shape routine}
