% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_effect.R
\name{causal_effect}
\alias{causal_effect}
\title{Causal Effect Identification}
\usage{
causal_effect(g, y, x = character(0), z = character(0), v = integer(0))
}
\arguments{
\item{g}{A \code{dag} object depicting the causal diagram \eqn{G}.}

\item{y}{A \code{character} vector of response variables \eqn{Y}.}

\item{x}{A \code{character} vector of intervention variables \eqn{X}.}

\item{z}{An optional \code{character} vector of conditioning variables \eqn{Z}.}

\item{v}{An optional named \code{integer} vector giving the value assignments
for observed variables in the model, i.e. \eqn{V = v} or
for a subset of \eqn{V}.}
}
\value{
An object of class \code{query} which is a \code{list} with the following
components:
\itemize{
\item \code{id}\cr A \code{logical} value that is \code{TRUE} if the query is identifiable and
\code{FALSE} otherwise.
\item \code{formula}\cr A  \code{functional} object expressing the causal effect in terms
of the joint probability distribution \eqn{P(v)} for identifiable queries
or \code{NULL} if the query is not identifiable.
\item \code{data}\cr The available data, for \code{causal_effect} this is always
\code{"observations"}
\item \code{causaleffect}\cr The original query \eqn{P(y|do(x),z)} as a \code{probability}
object.
\item \code{undefined}\cr A \code{logical} value, this is always \code{FALSE} for
\code{causaleffect}
}
}
\description{
Identify a causal effect of the form \eqn{P(y|do(x),z)} from \eqn{P(v)} in
\eqn{G}.
}
