% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_validate.R
\name{cff_validate}
\alias{cff_validate}
\title{Validate a \code{CITATION.cff} file or a \code{\link{cff}} object}
\usage{
cff_validate(x = "CITATION.cff", verbose = TRUE)
}
\arguments{
\item{x}{This is expected to be either a \code{\link{cff}} object created
with \code{\link[=cff_create]{cff_create()}} or the path to a \code{CITATION.cff} file to be validated.}

\item{verbose}{Logical \code{TRUE/FALSE}. On \code{TRUE} the function would display
informative messages.}
}
\value{
A message indicating the result of the validation and an invisible
value \code{TRUE/FALSE}.
}
\description{
Validate a \code{CITATION.cff} file or a \code{\link{cff}} object created with
\code{\link[=cff_create]{cff_create()}} using the corresponding validation
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema.json}{schema.json}.
}
\examples{
\donttest{
# Full .cff example
cff_validate(system.file("examples/CITATION_complete.cff", package = "cffr"))

# Validate a cffr object
cffr <- cff_create("jsonlite")
class(cffr)
cff_validate(cffr)
}
\dontrun{
# .cff with errors
cff_validate(system.file("examples/CITATION_error.cff", package = "cffr"))
# If a CITATION file (note that is not .cff) it throws an error
cff_validate(system.file("CITATION", package = "cffr"))
}
}
\seealso{
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Guide to Citation File Format schema version 1.2.0}.

Other core functions: 
\code{\link{cff_create}()},
\code{\link{cff_write}()},
\code{\link{cff}()}
}
\concept{core functions}
