% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{cxy_geocode}
\alias{cxy_geocode}
\title{Batch Geocode Parsed Addresses}
\usage{
cxy_geocode(
  .data,
  id = NULL,
  street,
  city = NULL,
  state = NULL,
  zip = NULL,
  return = "locations",
  benchmark = "Public_AR_Current",
  vintage = NULL,
  timeout = 30,
  parallel = 1,
  class = "dataframe",
  output = "simple"
)
}
\arguments{
\item{.data}{data.frame containing columns with structured address data}

\item{id}{Optional String - Name of column containing unique ID}

\item{street}{String - Name of column containing street address}

\item{city}{Optional String - Name of column containing city}

\item{state}{Optional String - Name of column containing state}

\item{zip}{Optional String - Name of column containing zip code}

\item{return}{One of 'locations' or 'geographies' denoting returned information
from the API. If you would like Census geography data, you must specify
a valid vintage for your benchmark.}

\item{benchmark}{Optional Census benchmark to geocode against. To obtain current
valid benchmarks, use the \code{cxy_benchmarks()} function.}

\item{vintage}{Optional Census vintage to geocode against. You may use the
\code{cxy_vintages()} function to obtain valid vintages.}

\item{timeout}{Numeric, in minutes, how long until request times out}

\item{parallel}{Integer, number of cores greater than one if parallel requests
are desired. All operating systems now use a SOCK cluster, and the
dependencies are not longer suggested packages. Instead, they are
installed by default. Note that this value may not represent more cores
than the system reports are available. If it is larger, the maximum number
of available cores will be used.}

\item{class}{One of 'dataframe' or 'sf' denoting the output class. 'sf' will only return matched addresses.}

\item{output}{One of 'simple' or 'full' denoting the returned columns. Simple returns just coordinates.}
}
\value{
A data.frame or sf object containing geocoded results
}
\description{
Provides access to the US Census Bureau batch endpoints for locations and
geographies. The function implements iteration and optional parallelization
in order to geocode datasets larger than the API limit of 1,000 and more
efficiently than sending 10,000 per request. It also supports multiple outputs,
including (optionally, if \code{sf} is installed,) \code{sf} class objects.
}
\details{
Parallel requests are supported across platforms. If supported (POSIX platforms) the process is forked, otherwise a SOCK cluster is used (Windows).
You may not specify more cores than the system reports are available
}
\examples{
# load data
x <- stl_homicides[1:10,]

# geocode
cxy_geocode(x, street = 'street_address', city = 'city', state = 'state', zip = 'postal_code',
   return = 'locations', class = 'dataframe', output = 'simple')

}
