% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_census_api.R
\name{call_api_once}
\alias{call_api_once}
\title{Call Census API for a set of variables}
\usage{
call_api_once(variables_to_get, geoid, allgeos, data_source, year, period,
  api_key)
}
\arguments{
\item{variables_to_get}{A character vector of the desired variable names for
the Census API call, defined at \url{https://www.census.gov/data/developers/data-sets.html}}

\item{geoid}{A character string with a FIPS code, between 2 and 15 digits long.}

\item{allgeos}{(optional) A string identifying the type of geography for
which to collect data within the the requested \code{geoids}. Must be one
of \code{c('co', 'tr', 'bg', 'bl')}. For instance, if \code{allgeos =
"bg"}, will return all block groups within the given \code{geoids}.}

\item{data_source}{A string identifying whether the SF1 (decennial census) or
ACS data is desired.}

\item{year}{If \code{data_source = "acs"}, the final year of the summary
period. Default is \code{2013}.}

\item{period}{If \code{data_source = "acs"}, the length of aggregation period.
Default is \code{5}, or a 5-year aggregation table.}

\item{api_key}{The user's Census API key (as a character string). You can get
a free key from [Census](http://api.census.gov/data/key_signup.html). See
\code{vignette('censusr', package = 'censusr')} to setup a default key as
an environment variable.}
}
\value{
A code{data.frame} with the requested variables at the requested
  geography.
}
\description{
This is an internal function and is not intended for users. See instead
\link{call_census_api}.
}
