% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{time_to_million}
\alias{time_to_million}
\title{Number of days before a movie grosses $1M USD}
\value{
\item{time_to_million}{a tibble}
}
\description{
These data are a somewhat biased random sample of 551 movies released between
2015 and 2018. Columns include
}
\details{
\itemize{
\item \code{title}: a character string for the movie title.
\item \code{time}: number of days until the movie earns a million US dollars.
\item \code{event}: a binary value for whether the movie reached this goal. About 94\%
of the movies had observed events.
\item \code{released}: a date field for the release date.
\item \code{distributor}: a factor with the the name of the distributor.
\item \code{released_theaters}: the maximum number of theaters where the movie played
in the first two weeks of release.
\item \code{year}: the release year.
\item \code{rated}: a factor for the Motion Picture Association film rating.
\item \code{runtime}: the length of the movie (in minutes).
\item A set of indicators columns for the movie genre (e.g. \code{action}, \code{crime},
etc.).
\item A set of indicators for the language (e.g., \code{english}, \code{hindi}, etc.).
\item A set of indicators for countries where the movie was released (e.g., \code{uk},
\code{japan}, etc.)
}
}
\keyword{datasets}
