% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cell-rows-cell-cols.R
\name{cell_rows}
\alias{cell_rows}
\title{Specify cell limits only for rows}
\usage{
cell_rows(x)
}
\arguments{
\item{x}{numeric vector of row limits; if length greater than two, min and
  max will be taken with \code{NA.rm = TRUE}}
}
\value{
a \code{cell_limits} object
}
\description{
How does this differ from \code{cell_limits}? Here the input can have length
greater than 2, i.e. the rows can be specified as \code{1:n}. If the length
is greater than 2, both the min and max are taken with \code{NA.rm = TRUE}.
Note it is not possible to request non-contiguous rows, i.e. rows 1, 2, and
5. In this case, the requested rows will run from the minimum of 1 to the
maximum of 5.
}
\examples{
cell_rows(c(NA, 3))
cell_rows(c(7, NA))
cell_rows(4:16)
cell_rows(c(3, NA, 10))

dim(cell_rows(1:5))
}

