% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrInfluence.R
\name{influence.cdfqr}
\alias{dfbeta.cdfqr}
\alias{dfbetas.cdfqr}
\alias{influence.cdfqr}
\title{Influence Diagnosis For Fitted Cdfqr Object}
\usage{
\method{influence}{cdfqr}(model, method = "dfbeta", type = c("full",
  "location", "precision"), what = "full", plot = FALSE, ...)

\method{dfbeta}{cdfqr}(model, type = c("full", "location", "precision"),
  what = "full", ...)

\method{dfbetas}{cdfqr}(model, type = c("full", "location", "precision"),
  what = "full", ...)
}
\arguments{
\item{model}{A cdfqr model object}

\item{method}{Currently only 'dfbeta' method is available.}

\item{type}{A string that indicates whether the results for all paramters are to be returned, or only the location/dispersion submodel's parameters returned.}

\item{what}{for influence statistics based on coefficient values, indicate the predictor variables that needs to be tested.}

\item{plot}{if plot is needed.}

\item{...}{currently ignored.s}
}
\value{
A matrix, each row of which contains the estimated influence on parameters when that row's observation is removed from the sample.
}
\description{
Influence Diagnosis (dfbetas) For Fitted Cdfqr Object
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2', 't2', data = JurorData)
influcne <- influence(fit)
plot(influcne[,2])

\dontrun{
# Same as influence(fit)
dfbetval <- dfbetas(fit)
}

}
\seealso{
\code{\link[stats]{lm.influence}}, \code{\link[stats]{influence.measures}}
}

