% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opspec.R
\name{layout_by.rowrecs_to_blocks_spec}
\alias{layout_by.rowrecs_to_blocks_spec}
\title{Use transform spec to layout data.}
\usage{
\method{layout_by}{rowrecs_to_blocks_spec}(transform, table)
}
\arguments{
\item{transform}{object of class rowrecs_to_blocks_spec}

\item{table}{data.frame or relop.}
}
\value{
re-arranged data or data reference (relop).
}
\description{
Use transform spec to layout data.
}
\examples{

d <- wrapr::build_frame(
  "id"  , "AUC", "R2" |
    1   , 0.7  , 0.4  |
    2   , 0.8  , 0.5  )

transform <- rowrecs_to_blocks_spec(
  wrapr::qchar_frame(
    "measure", "value" |
    "AUC"    , AUC     |
    "R2"     , R2      ),
  recordKeys = "id")

print(transform)
layout_by(transform, d)

}
